import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { MvpServices } from '../../../../services/mvp-services';


@Component({
  selector: 'app-mvp-add-relationships',
  templateUrl: './mvp-add-relationships.component.html',
  styleUrls: ['./mvp-add-relationships.component.scss']
})
export class MvpAddRelationshipsComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  selectedPredicateUri: any;
  selectedBookmark: any;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    public mvpServices: MvpServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getPredicateList() {
    return this.mvpServices.getPredicateLabelList();
  }

  anyPredicateExists() {
    return this.getPredicateList() != null && this.getPredicateList().length > 0; 
  }

  anyBookmarksExists() {
    return this.mvpServices.getMvpBookmarkedConceptList() != null && this.mvpServices.getMvpBookmarkedConceptList().length > 0; 
  }

    onSubmit() {
    if (this.selectedPredicateUri != null && this.selectedPredicateUri.length > 0 &&
      this.selectedPredicateUri != "0" &&
      this.selectedBookmark != null && this.selectedBookmark != "0" &&
      this.selectedBookmark.conceptUri != null &&
      this.selectedBookmark.conceptUri.length > 0) {
      this.mvpObject.predicate = this.selectedPredicateUri;
      this.mvpObject.object = this.selectedBookmark.conceptUri;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
